﻿/**************************************************************************************************
BSD License
The BSD License (http://www.opensource.org/licenses/bsd-license.php) specifies the terms and
conditions of use for FAVideo:

Copyright (c) 2007. Adobe Systems Incorporated.
All rights reserved.

Redistribution and use in source and binary forms, with or without modification, are permitted
provided that the following conditions are met:

  • Redistributions of source code must retain the above copyright notice, this list of conditions
    and the following disclaimer.
  • Redistributions in binary form must reproduce the above copyright notice, this list of
    conditions and the following disclaimer in the documentation and/or other materials provided
	with the distribution.
  • Neither the name of Adobe Systems Incorporated nor the names of its contributors may be used
    to endorse or promote products derived from this software without specific prior written
	permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR
IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIESOF MERCHANTABILITY AND
FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR
CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER
IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.


For more information and updates for FAVideo, please visit:
http://www.adobe.com/go/favideo/
**************************************************************************************************/

import mx.events.EventDispatcher;
import mx.utils.Delegate;

class com.adobe.favideo.utils.IdleWatcher {
	
// Private properties:
	private var _isIdle:Boolean = false;
	private var idleInterval:Number;
	private var idleDelay:Number = 2000;
	
// EventDispatcher methods:
	public var addEventListener:Function;
	public var removeEventListener:Function;
	private var dispatchEvent:Function;
	
// Initialization:
	public function IdleWatcher(delay:Number) {
		idleDelay = (delay == null) ? idleDelay : delay;
		
		EventDispatcher.initialize(this);
		
		Mouse.addListener(this);
		Key.addListener(this);
	}
	
// Public methods:
	public function stop():Void {
		clearInterval(idleInterval);
		delete idleInterval;
		Mouse.removeListener(this);
		Key.removeListener(this);
	}
	
	public function start():Void {
		clearInterval(idleInterval);
		idleInterval = setInterval(this, "onIdleTimeout", idleDelay);
		Mouse.addListener(this);
		Key.addListener(this);
	}
	
	public function get isIdle():Boolean {
		return _isIdle;
	}
	
// Private methods:
	private function interuptIdle():Void {
		var wasIdle:Boolean = _isIdle;
		_isIdle = false;
		start();
		if (wasIdle) {
			dispatchEvent({type:'idleInterrupted'});
		}
	}
	
	private function onMouseMove():Void {
		interuptIdle();
	}
	private function onKeyDown():Void {
		interuptIdle();
	}
	
	private function onIdleTimeout(event:Object):Void {
		_isIdle = true;
		stop();
		dispatchEvent({type:'idleTimeout'});
	}
	
}