﻿/**************************************************************************************************
BSD License
The BSD License (http://www.opensource.org/licenses/bsd-license.php) specifies the terms and
conditions of use for FAVideo:

Copyright (c) 2007. Adobe Systems Incorporated.
All rights reserved.

Redistribution and use in source and binary forms, with or without modification, are permitted
provided that the following conditions are met:

  • Redistributions of source code must retain the above copyright notice, this list of conditions
    and the following disclaimer.
  • Redistributions in binary form must reproduce the above copyright notice, this list of
    conditions and the following disclaimer in the documentation and/or other materials provided
	with the distribution.
  • Neither the name of Adobe Systems Incorporated nor the names of its contributors may be used
    to endorse or promote products derived from this software without specific prior written
	permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR
IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIESOF MERCHANTABILITY AND
FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR
CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER
IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.


For more information and updates for FAVideo, please visit:
http://www.adobe.com/go/favideo/
**************************************************************************************************/

/**
*  VideoAlign, this is modified from the original fl.video.VideoAlign class that is used by Flash 9's FLVPlayback component.
*/
class com.adobe.favideo.VideoAlign {
		
	/**
	 * Specifies that the video is aligned in the center.
	 *
	 */
	public static var CENTER:String = "center";

	/**
	 * Specifies that the video is aligned at the top.
	 *
	 */
	public static var TOP:String = "top";

	/**
	 * Specifies that the video is aligned on the left.
	 *
	 */
	public static var LEFT:String= "left";

	/**
	 * Specifies that the video is aligned at the bottom.
	 *
	 */
	public static var BOTTOM:String = "bottom";
	
	/**
	 * Specifies that the video is aligned to the right.
	 *
	 */
	public static var RIGHT:String  = "right";

	/**
	 * Specifies that the video is aligned in the top-left corner.
	 *
	 */
	public static var TOP_LEFT:String = "topLeft";

	/**
	 * Specifies that the video is aligned in the top-right corner.
	 *
	 */
	public static var TOP_RIGHT:String = "topRight";

	/**
	 * Specifies that the video is aligned in the bottom-left corner.
	 *
	 */
	public static var BOTTOM_LEFT:String = "bottomLeft";

	/**
	 * Specifies that the video is aligned in the bottom-right corner.
	 * 
	 */
	public static var BOTTOM_RIGHT:String  = "bottomRight";
}