/**
*Resource Manager class
*For working with AWS S3 buckets
**/


function ResourceManager()
{

    this.bucket = fwdmConfig.bucket;
    var self = this;
    this.s3 = new AWS.S3({ region: fwdmConfig.region });


    var getObjectPromise = self.s3.getObject({ Bucket: self.bucket, Key: fwdmConfig.directory }).promise();
    //function will triggern the correct callback function
    getObjectPromise.then(function(data){
        //alert("AWS bucket ready");
        vm.getDatabase();
    },
    function(error){
      //this is the error that occurs when changing pages after an hour has elapsed???
      console.log(error);
        alert("Unable to reach AWS bucket "+error);
      //loadPage();
    })

    this.getResource=function(dir)
    {
       if(dir)key=dir.replace('./','');
       var resource="";
       self.s3.getSignedUrl('getObject', {Bucket:self.bucket, Key:key}, function (err, url) {
          if(err){
              console.log(err);
          }
          else{
            resource=url;
            if(vm.isUpload)$('#fileinfo .progress').show();
          }
       });
       return resource;
    }

    this.getFiles=function(directory,item)
    {
        var key=directory+"/";
        self.s3.listObjectsV2({Bucket:self.bucket,Prefix:key,StartAfter:key}, function(err, data) {
         if(err){
              console.log(err);
              loadPage();
          }
          else vm.directory.display(data,directory,item);

        })
    }

    this.newDirectory=function(directory,name)
    {
        var key=directory+"/"+name+"/";
        self.s3.putObject({Bucket:self.bucket, Key:key},function(err){
         if(err){
              console.log(err);
              loadPage();
          }
          else self.getFiles(directory,name);
        })
    }

    this.deleteObjects=function(directory,keys)
    {
        for(i=0;i<keys.length;i++){
          self.s3.deleteObject({Bucket:self.bucket, Key:keys[i]}, function(err, data) {
          if(err){
              alert("Error: "+err);
           }
           else self.getFiles(directory);
          });
        }

    }

    this.pasteObjects=function(from,to,mode,items)
    {
        for(i=0;i<items.length;i++){
          var key=from+"/"+items[i].path;
          var name=items[i].path;
          var type=items[i].type;
          self.copyRecursive(key,name,type,to);
          //if mode=cut then delete 'from' objects
          if(mode=="cut"){
            self.s3.deleteObject({Bucket:self.bucket, Key:key}, function(err, data) {
               if(err){
                   alert("Error: "+err);
               }
            });
          }
        }

    }

    this.copyRecursive=function(key,name,type,to){
        var copyto=to+"/"+name;
        if(type=="file"){

          self.s3.copyObject({Bucket:self.bucket,CopySource:"/"+self.bucket+"/"+key,Key:copyto}, function(err, data) {
             if (err) alert(err+" "+err.stack);
             else{
                 self.getFiles(to);
             }
          });

        }

    }

    this.saveDatabase=function(data)
    {
         var key="masterdb.js";
         self.upload=self.s3.upload({Bucket:self.bucket,Key: key, ContentType: 'text/javascript', Body: data}, function (err, data) {
            if (err) alert(err+" "+err.stack);
            else{
               $('.filewear-status').html('...connected to database');
            }
         });
    }

    this.uploadFiles=function(directory,files)
    {
         var key=directory+"/"
         for(i=0;i<files.length;i++){
            self.upload=self.s3.upload({Bucket:self.bucket,Key: key+files[i].name, ContentType: files[i].type, Body: files[i]}, function (err, data) {
               if (err) alert(err+" "+err.stack);
               else{
                  self.extractText(key+files[files.length-1].name);
                  self.getFiles(directory,files[files.length-1].name);
               }
            });
         }
         self.upload.on('httpUploadProgress', function (progress) {
               //console.log(progress.loaded + " of " + progress.total + " bytes");
               var val=Math.floor((progress.loaded/progress.total)*100);
               $('#progressbar').progressbar( "value", val);

         });

    }


    this.uploadFilesAsScript=function(directory,file)
    {
         vm.mode="uploading";
         var key=directory+"/";
         self.convertToBase64(key,file,directory);


    }

    this.extractText=function(key)
    {
       self.s3.getSignedUrl('getObject', {Bucket:self.bucket, Key:key}, function (err, url) {
          if(err){
              console.log(err);
              loadPage();
          }
          else{
                function gettext(pdfUrl){
                var pdf = PDFJS.getDocument(pdfUrl);
                return pdf.then(function(pdf) { // get all pages text
                     var maxPages = pdf.pdfInfo.numPages;
                     var fingerprint = pdf.pdfInfo.fingerprint;
                     var countPromises = []; // collecting all page promises
                     for (var j = 1; j <= maxPages; j++) {
                        var page = pdf.getPage(j);

                        var txt = "";
                        countPromises.push(page.then(function(page) { // add page promise
                            var textContent = page.getTextContent();
                            return textContent.then(function(text){ // return content promise
                                return text.items.map(function (s) { return s.str; }).join(''); // value page text 

                            });
                        }));
                     }
                     // Wait for all pages and join text
                     return Promise.all(countPromises).then(function (texts) {
                       
                       return fingerprint+" - "+texts.join('');
                     });
                });
                }
                // waiting on gettext to finish completion, or error
                gettext(url).then(function (text) {
                  alert('parse ' + text);
                }, function (reason) {
                  console.error(reason);
                });
          }
       })


    }

    this.convertToBase64=function(key,selectedFile,directory) {
        //Read File
        //var selectedFile = document.getElementById("inputFile").files;
        //Check File is not Empty
        if (selectedFile) {
            // Select the very first file from list
            var fileToLoad = selectedFile;
            // FileReader function for read the file.
            var fileReader = new FileReader();
            var base64;
            // Onload of file read the file content
            fileReader.onload = function(fileLoadedEvent) {
                base64 = fileLoadedEvent.target.result;
                // Print data in console
                self.upload=self.s3.upload({Bucket:self.bucket,Key: key+selectedFile.name+".js", ContentType: "text/javascript", Body:'var body="'+base64.split(',')[1]+'";' }, function (err, data) {
                   if (err) alert(err+" "+err.stack);
                   else{
                      //self.getFiles(directory,selectedFile.name+".js");
                      //$('#filemanager').dialog('close');
                      //vm.openDBManager(PDFViewerApplication.pdfDocument.fingerprint)
                      vm.loadDocument(key+selectedFile.name+".js",selectedFile.name.replace(/\.[^/.]+$/, ""));

                   }
                });

                self.upload.on('httpUploadProgress', function (progress) {
                      //console.log(progress.loaded + " of " + progress.total + " bytes");
                      var val=Math.floor((progress.loaded/progress.total)*100);
                      $('#modal .progress-bar').css('width', val+'%').attr('aria-valuenow', val).text(val+'%');

                });
                /*console.log(base64.split(',')[1]);
                console.log("all done");
                alert("All done");
                return 'var body="'+base64.split(',')[1]+"';";*/
                //alert("all done");
            };
            // Convert data to base64
            try{
               fileReader.readAsDataURL(fileToLoad);
            }
            catch(e){
               alert(e);
            }
        }
    }


    //update token when document is clicked
    setInterval(function () {
        var poolData = {
            UserPoolId: fwdmConfig.UserPoolId,
            ClientId: fwdmConfig.ClientId
        };
        var userPool = new AWSCognito.CognitoIdentityServiceProvider.CognitoUserPool(poolData);
        var cognitoUser = userPool.getCurrentUser();

        if (cognitoUser != null) {
            cognitoUser.getSession(function (err, result) {
                if (result) {
                    console.log('Clicked');
                    //userAccess = result.getIdToken().getJwtToken();
                    // Add the User's Id Token to the Cognito credentials login map.
                    AWS.config.credentials = new AWS.CognitoIdentityCredentials({
                        IdentityPoolId: fwdmConfig.IdentityPoolId,
                        Logins: {
                            'cognito-idp.us-east-1.amazonaws.com/us-east-1_l5tCBR3sI': result.getIdToken().getJwtToken()
                        }
                    });
                    //$(document).trigger("AWSReady");
                    //this.s3 =  new AWS.S3();
                    console.log("Cognito Update", result.getIdToken().getJwtToken());
                    awsready = true;
                }
                else {
                    console.log("NO SESSION");
                }
            });
        }

        AWS.config.credentials.refresh((error) => {
          if (error) {
            console.error(error);
          } else {
            console.log('Successfully logged!');
            self.s3 = new AWS.S3({ region: fwdmConfig.region });
          }
        });

     },1000*10);


}