/*
    A simple jQuery _modal (http://github.com/kylefox/jquery-_modal)
    Version 0.5.5
*/
(function($) {

  var current = null;

  $._modal = function(el, options) {
    $._modal.close(); // Close any open _modals.
    var remove, target;
    this.$body = $('body');
    this.options = $.extend({}, $._modal.defaults, options);
    this.options.doFade = !isNaN(parseInt(this.options.fadeDuration, 10));
    if (el.is('a')) {
      target = el.attr('href');
      //Select element by id from href
      if (/^#/.test(target)) {
        this.$elm = $(target);
        if (this.$elm.length !== 1) return null;
        this.open();
      //AJAX
      } else {
        this.$elm = $('<div>');
        this.$body.append(this.$elm);
        remove = function(event, _modal) { _modal.elm.remove(); };
        this.showSpinner();
        el.trigger($._modal.AJAX_SEND);
        $.get(target).done(function(html) {
          if (!current) return;
          el.trigger($._modal.AJAX_SUCCESS);
          current.$elm.empty().append(html).on($._modal.CLOSE, remove);
          current.hideSpinner();
          current.open();
          el.trigger($._modal.AJAX_COMPLETE);
        }).fail(function() {
          el.trigger($._modal.AJAX_FAIL);
          current.hideSpinner();
          el.trigger($._modal.AJAX_COMPLETE);
        });
      }
    } else {
      this.$elm = el;
      this.open();
    }
  };

  $._modal.prototype = {
    constructor: $._modal,

    open: function() {
      var m = this;
      if(this.options.doFade) {
        this.block();
        setTimeout(function() {
          m.show();
        }, this.options.fadeDuration * this.options.fadeDelay);
      } else {
        this.block();
        this.show();
      }
      if (this.options.escapeClose) {
        $(document).on('keydown._modal', function(event) {
          if (event.which == 27) $._modal.close();
        });
      }
      if (this.options.clickClose) this.blocker.click($._modal.close);
    },

    close: function() {
      this.unblock();
      this.hide();
      $(document).off('keydown._modal');
    },

    block: function() {
      var initialOpacity = this.options.doFade ? 0 : this.options.opacity;
      this.$elm.trigger($._modal.BEFORE_BLOCK, [this._ctx()]);
      this.blocker = $('<div class="jquery-_modal blocker"></div>').css({
        top: 0, right: 0, bottom: 0, left: 0,
        width: "100%", height: "100%",
        position: "fixed",
        zIndex: this.options.zIndex,
        background: this.options.overlay,
        opacity: initialOpacity
      });
      this.$body.append(this.blocker);
      if(this.options.doFade) {
        this.blocker.animate({opacity: this.options.opacity}, this.options.fadeDuration);
      }
      this.$elm.trigger($._modal.BLOCK, [this._ctx()]);
    },

    unblock: function() {
      if(this.options.doFade) {
        this.blocker.fadeOut(this.options.fadeDuration, function() {
          $(this).remove();
        });
      } else {
        this.blocker.remove();
      }
    },

    show: function() {
      this.$elm.trigger($._modal.BEFORE_OPEN, [this._ctx()]);
      if (this.options.showClose) {
        this.closeButton = $('<a href="#close-_modal" rel="_modal:close" class="close-_modal ' + this.options.closeClass + '">' + this.options.closeText + '</a>');
        this.$elm.append(this.closeButton);
      }
      this.$elm.addClass(this.options._modalClass + ' current');
      this.center();
      if(this.options.doFade) {
        this.$elm.fadeIn(this.options.fadeDuration);
      } else {
        this.$elm.show();
      }
      this.$elm.trigger($._modal.OPEN, [this._ctx()]);
    },

    hide: function() {
      this.$elm.trigger($._modal.BEFORE_CLOSE, [this._ctx()]);
      if (this.closeButton) this.closeButton.remove();
      this.$elm.removeClass('current');

      if(this.options.doFade) {
        this.$elm.fadeOut(this.options.fadeDuration);
      } else {
        this.$elm.hide();
      }
      this.$elm.trigger($._modal.CLOSE, [this._ctx()]);
    },

    showSpinner: function() {
      if (!this.options.showSpinner) return;
      this.spinner = this.spinner || $('<div class="' + this.options._modalClass + '-spinner"></div>')
        .append(this.options.spinnerHtml);
      this.$body.append(this.spinner);
      this.spinner.show();
    },

    hideSpinner: function() {
      if (this.spinner) this.spinner.remove();
    },

    center: function() {
      this.$elm.css({
        position: 'fixed',
        top: "50%",
        left: "50%",
        marginTop: - (this.$elm.outerHeight() / 2),
        marginLeft: - (this.$elm.outerWidth() / 2),
        zIndex: this.options.zIndex + 1
      });
    },

    //Return context for custom events
    _ctx: function() {
      return { elm: this.$elm, blocker: this.blocker, options: this.options };
    }
  };

  //resize is alias for center for now
  $._modal.prototype.resize = $._modal.prototype.center;

  $._modal.close = function(event) {
    if (!current) return;
    if (event) event.preventDefault();
    current.close();
    var that = current.$elm;
    current = null;
    return that;
  };

  $._modal.resize = function() {
    if (!current) return;
    current.resize();
  };

  // Returns if there currently is an active _modal
  $._modal.isActive = function () {
    return current ? true : false;
  }

  $._modal.defaults = {
    overlay: "#000",
    opacity: 0.75,
    zIndex: 1,
    escapeClose: true,
    clickClose: true,
    closeText: 'Close',
    closeClass: '',
    _modalClass: "_modal",
    spinnerHtml: null,
    showSpinner: true,
    showClose: true,
    fadeDuration: null,   // Number of milliseconds the fade animation takes.
    fadeDelay: 1.0        // Point during the overlay's fade-in that the _modal begins to fade in (.5 = 50%, 1.5 = 150%, etc.)
  };

  // Event constants
  $._modal.BEFORE_BLOCK = '_modal:before-block';
  $._modal.BLOCK = '_modal:block';
  $._modal.BEFORE_OPEN = '_modal:before-open';
  $._modal.OPEN = '_modal:open';
  $._modal.BEFORE_CLOSE = '_modal:before-close';
  $._modal.CLOSE = '_modal:close';
  $._modal.AJAX_SEND = '_modal:ajax:send';
  $._modal.AJAX_SUCCESS = '_modal:ajax:success';
  $._modal.AJAX_FAIL = '_modal:ajax:fail';
  $._modal.AJAX_COMPLETE = '_modal:ajax:complete';

  $.fn._modal = function(options){
    if (this.length === 1) {
      current = new $._modal(this, options);
    }
    return this;
  };

  // Automatically bind links with rel="_modal:close" to, well, close the _modal.
  $(document).on('click._modal', 'a[rel="_modal:close"]', $._modal.close);
  $(document).on('click._modal', 'a[rel="_modal:open"]', function(event) {
    event.preventDefault();
    $(this)._modal();
  });
})(jQuery);